/*************************************************************************
 * The contents of this file are subject to the MYRICOM MX AND GM-2      *
 * MAPPING SOFTWARE AND DOCUMENTATION LICENSE (the "License"); User may  *
 * not use this file except in compliance with the License.  The full    *
 * text of the License can found in mapper directory in LICENSE.TXT      *
 *                                                                       *
 * Software distributed under the License is distributed on an "AS IS"   *
 * basis, WITHOUT WARRANTY OF ANY KIND, either express or implied.  See  *
 * the License for the specific language governing rights and            *
 * limitations under the License.                                        *
 *                                                                       *
 * Copyright 2003 - 2004 by Myricom, Inc.  All rights reserved.          *
 *************************************************************************/

/*
  converts a new style routing file back to the
  old
*/

#include <stdarg.h>

#include "lx.h"
#include "lx_map_file.h"
#include "lx_routing.h"
#include "lx_route_file.h"

lx_t lx;

static void usage (char*s)
{
  fprintf (stderr, "usage: %s <map file> [<route file>]\n", s);
  exit (0);
}

int main (int argc, char*argv [])
{
  lx_map_t*m;
  FILE*fp;
  int i, from, num_hosts, num_ports, num_routes, line_count;
  lx_route_table_entry_t*entries, *e;
  lx_node_t*first;
  
  mi_verbose_flag = 0;

  if (argc < 2)
    usage (argv [0]);
  
  if (!(fp = fopen (argv [1], "r")))
  {
    fprintf (stderr, "couldn't open %s\n", argv [1]);
    usage (argv [0]);
  }
  
  lx_init (&lx);
  
  if (!lx_map_file_read (fp, &lx.maps [0], &first))
  {
    fprintf (stderr, "lx_map_file_read () failed\n");
    return 0;
  }

  m = lx.maps;
  fprintf (stderr, "%d hosts and %d xbars\n", m->num_hosts, m->num_xbars);

  if (!(fp = argc == 2 ? stdin : fopen (argv [2], "r")))
  {
    fprintf (stderr, "couldn't open %s\n", argv [2]);
    usage (argv [0]);
  }
  
  line_count = 0;
  fprintf (stdout, "%d 1\n", m->num_hosts);
  
  while ((entries = lx_route_file_read_routes (fp, &from, &num_hosts, &num_ports, &num_routes, &line_count)))
  {
    insist (from >= 0 && from < m->num_hosts);
    insist (num_hosts == m->num_hosts);
    insist (num_ports > 0 && num_ports < LX_HOST_SIZE);
    insist (num_routes > 0);

    fprintf (stdout, "h%d (%d %d)\n", from, m->num_hosts, m->num_hosts * LX_EFFECTIVE_ROUTE_SIZE);

    for (i = 0; i < num_hosts; i++)
    {
      e = lx_route_file_entry (entries, num_ports, num_hosts, num_routes, 0, i, 0, 0);
      insist (e);
      fprintf (stdout, "h%d %s\n", i, lx_print_route (e->route.hops, e->route.length));
      
    }
    free (entries);
  }
  
  return 1;
  except: return 0;
}
